package com.hero.objects.skills;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ProfessionalSkill extends Skill {

	private static String xmlID = "PROFESSIONAL_SKILL";

	public ProfessionalSkill(Element template) {
		super(template, ProfessionalSkill.xmlID);
		alias = "PS";
	}

	/**
	 * Returns an int representing the value that must be rolled under to
	 * succeed with the Skill.
	 * 
	 * @return
	 */
	public int getRollValue() {
		int ret = 0;
		if (isFamiliarity()) {
			if (isEveryman()) {
				ret = 11;
			} else if (getFamiliarityRoll() > 0) {
				ret = getFamiliarityRoll();
			} else {
				ret = 8;
			}
		} else if (isProficiency()) {
			if (getProficiencyRoll() > 0) {
				ret = getProficiencyRoll();
			} else {
				ret = 10;
			}
		} else if (isFocus() && HeroDesigner.getActiveHero() != null) {
			int roll = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();
			if (getLevels() < 0) {
				roll = getMinimumLevel();
			} else {
				roll = roll + getLevels();
			}
			ret = roll;
		} else if (HeroDesigner.getActiveHero() != null) {
			Characteristic charac = HeroDesigner.getActiveHero()
					.getCharacteristic(characteristic);
			int roll = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();
			if ((charac != null) && !charac.getXMLID().equals("GENERAL")) {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) (Rounder.roundHalfUp(charac.getPrimaryValue()
								/ HeroDesigner.getActiveHero().getRules()
										.getSkillRollDenominator()) + getLevels()
								* getLevelValue());
			} else if (characteristic == Constants.GENERAL) {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) (Rounder.roundHalfUp(HeroDesigner
								.getActiveTemplate().getGeneralLevel()
								/ HeroDesigner.getActiveHero().getRules()
										.getSkillRollDenominator()) + getLevels()
								* getLevelValue());
			} else {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) Rounder.roundHalfUp(getLevels()
								* getLevelValue());
			}
			ret = roll;
		} else {
			int roll = 9
					+ (int) (Rounder.roundHalfUp(HeroDesigner
							.getActiveTemplate().getGeneralLevel()
							/ 5) + getLevels()
							* getLevelValue());
			ret = roll;
		}

		return ret;
	}

	public int getSecondaryRollValue() {
		int ret = 0;
		if (isFamiliarity()) {
			if (isEveryman()) {
				ret = 11;
			} else if (getFamiliarityRoll() > 0) {
				ret = getFamiliarityRoll();
			} else {
				ret = 8;
			}
		} else if (isProficiency()) {
			if (getProficiencyRoll() > 0) {
				ret = getProficiencyRoll();
			} else {
				ret = 10;
			}
		} else if (isFocus() && HeroDesigner.getActiveHero() != null) {
			int roll = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();
			if (getLevels() < 0) {
				roll = getMinimumLevel();
			} else {
				roll = roll + getLevels();
			}
			ret = roll;
		} else if (HeroDesigner.getActiveHero() != null) {
			Characteristic charac = HeroDesigner.getActiveHero()
					.getCharacteristic(characteristic);
			int roll = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();
			int roll2 = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();

			if ((charac != null) && !charac.getXMLID().equals("GENERAL")) {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) (Rounder.roundHalfUp(charac.getPrimaryValue()
								/ HeroDesigner.getActiveHero().getRules()
										.getSkillRollDenominator()) + getLevels()
								* getLevelValue());
				roll2 = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) (Rounder.roundHalfUp(charac.getSecondaryValue()
								/ HeroDesigner.getActiveHero().getRules()
										.getSkillRollDenominator()) + getLevels()
								* getLevelValue());
			} else if (characteristic == Constants.GENERAL) {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) (Rounder.roundHalfUp(HeroDesigner
								.getActiveTemplate().getGeneralLevel()
								/ HeroDesigner.getActiveHero().getRules()
										.getSkillRollDenominator()) + getLevels()
								* getLevelValue());
				roll2 = roll;
			} else {
				roll = HeroDesigner.getActiveHero().getRules()
						.getSkillRollBase()
						+ (int) Rounder.roundHalfUp(getLevels()
								* getLevelValue());
				roll2 = roll;
			}
			ret = roll2;
		} else {
			int roll = 9
					+ (int) (Rounder.roundHalfUp(HeroDesigner
							.getActiveTemplate().getGeneralLevel()
							/ 5) + getLevels()
							* getLevelValue());
			ret = roll;
		}

		return ret;
	}

	@Override
	public String getColumn2Output() {
		if (levelsOnly) {
			return getLevelOnlyOutput();
		}
		String ret = getAlias();
		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i> " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ": " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += ": " + getSelectedOption().getAlias();
		}
		if (!HeroDesigner.getInstance().getPrefs().useWG()
				&& (getCharacteristicChoices() != null)
				&& (getCharacteristicChoices().size() > 1)
				&& !(getCharacteristic() == Constants.GENERAL)) {
			ret += " ("
					+ Constants.getCharacteristicString(getCharacteristic())
					+ "-based)";
		}
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += " (";
			ret += adderString;
			ret += ")";
		}
		ret += getModifierString();
		if (showRoll) ret += " " + getRoll();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}
}